package gov.va.med.mhv.login.hook;

import java.util.Date;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PerformerTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.AccountActivityCreatorService;

@Component
public class PreLogoutAction extends Action{

	private static Log log = LogFactoryUtil.getLog(PreLogoutAction.class);

	private AccountActivityCreatorService accountActivityCreatorService;

	//when user logs out a record is inserted in to Activity table for audit purpose
	@Override
	public void run(HttpServletRequest request, HttpServletResponse response)
			throws ActionException {
		try {
			HttpSession session = request.getSession();
			String username=null;
			Long userProfileId=null;
			String customPreTimeoutExpiration = null;
			if(session.getAttribute("LIFERAY_SHARED_userid") != null){
				username = (String)session.getAttribute("LIFERAY_SHARED_userid");
			}
			if(session.getAttribute("LIFERAY_SHARED_userprofileid") != null){
				userProfileId= (Long)session.getAttribute("LIFERAY_SHARED_userprofileid");
			}
			
			if(session.getAttribute("CustomPreSessionExpireAction") != null){
				customPreTimeoutExpiration= (String)session.getAttribute("CustomPreSessionExpireAction");
			}			

			// Need to check if delegation exists and perform AAL entries and check if it is not the timeout scenario
			if(username != null &&  userProfileId != null && customPreTimeoutExpiration==null){
				if((session.getAttribute("showDelegateUserText") != null) && (boolean)session.getAttribute("showDelegateUserText")) {
					System.out.println("PreLogout - Delegation is NOT NULL");
					createLogoutActivityForDelegation(username,userProfileId,request);
				}else{
					createLogoutActivity(username,userProfileId);
				}
			}

			String sessionId = session.getId();
			session.invalidate();
			Cookie[] cookies = request.getCookies();
		    for (Cookie cookie : cookies) {
		      if (sessionId.equalsIgnoreCase(cookie.getValue())) {
		        cookie.setMaxAge(0);
		        cookie.setValue(null);
		        cookie.setDomain(request.getServerName());
		        cookie.setPath(request.getServletContext().getContextPath() + "/");
		        cookie.setSecure(request.isSecure());
		        response.addCookie(cookie);
		        break;
		      }
		    }

		} catch (Exception e) {
			log.error("Error in Pre logout", e);
		}
	}

	private void createLogoutActivityForDelegation(String username, Long userProfileId, HttpServletRequest request) {

		System.out.println("createLogoutActivityForDelegation - Logout");
		if(log.isDebugEnabled()){
			log.debug("createLogoutActivityForDelegation - Logout");
		}

		try {
			ActivityDTO logoutActivity = new ActivityDTO();
			logoutActivity.setAction(ActivityActionTypeEnumeration.LOGOUT_WITH_MY_HEALTHEVET.getDescription());
			logoutActivity.setActivityType("Logout");
			logoutActivity.setUserProfileId(userProfileId);
			logoutActivity.setStatus(Boolean.TRUE);
			//logoutActivity.setPerformerType(PerformerTypeEnumeration.valueOf("Healthcare_Proxy_Full").toString());
			logoutActivity.setPerformerType(ActivityActorTypeEnumeration.HEALTHCARE_PROXY_FULL.getDescription());
			logoutActivity.setDetailValue("Performed by Delegate: "+(String) request.getSession().getAttribute("LIFERAY_SHARED_userid_delegatee_fullname"));
			logoutActivity.setCompletionTime(new Date());

			getAccountActivityCreatorService().createAccountActivityLog(logoutActivity);
		} catch (MHVException e) {
			throw new RuntimeException("Error Creating Account Activity Log for Delegation - Logout", e);
		}
		if(log.isDebugEnabled()){
			log.debug("Account Activity Log for Delegation - Logout Created");
		}

	}

	private void createLogoutActivity(String username, Long userProfileId){

		if(log.isDebugEnabled()){
			log.debug("Creating Account Activity Log - Logout");
		}

		try {
			ActivityDTO logoutActivity = new ActivityDTO();
			logoutActivity.setAction(ActivityActionTypeEnumeration.LOGOUT_WITH_MY_HEALTHEVET.getDescription());
			logoutActivity.setActivityType("Logout");
			logoutActivity.setUserProfileId(userProfileId);
			logoutActivity.setStatus(Boolean.TRUE);
			logoutActivity.setPerformerType(PerformerTypeEnumeration.valueOf("Self").toString());
			logoutActivity.setDetailValue("None");
			logoutActivity.setCompletionTime(new Date());

			getAccountActivityCreatorService().createAccountActivityLog(logoutActivity);
		} catch (MHVException e) {
			// TODO: Figure out if this is really the right thing to do here.
			// TODO: Throw runtime exception???
			throw new RuntimeException("Error Creating Account Activity Log - Logut", e);
		}
		if(log.isDebugEnabled()){
			log.debug("Account Activity Log - Logout Created");
		}
	}

	private AccountActivityCreatorService getAccountActivityCreatorService() {
		if(this.accountActivityCreatorService == null) {
			this.accountActivityCreatorService = (AccountActivityCreatorService)ApplicationContextProvider.getApplicationContext().getBean("activityProxy");
		}

		return this.accountActivityCreatorService;
	}
}
